@echo off
title ScoreInvest Portfolio - Compilation
color 0A

echo.
echo ========================================================================
echo     SCOREINVEST PORTFOLIO TRACKER v2.0
echo     Compilation automatique pour Windows
echo ========================================================================
echo.

:: Verifier Python
echo [1/5] Verification de Python...
python --version >nul 2>&1
if errorlevel 1 (
    color 0C
    echo.
    echo ERREUR: Python n'est pas installe ou pas dans le PATH
    echo.
    echo Telechargez Python sur: https://www.python.org/downloads/
    echo IMPORTANT: Cochez "Add Python to PATH" pendant l'installation !
    echo.
    pause
    exit /b 1
)

for /f "tokens=2" %%i in ('python --version 2^>^&1') do set PYVER=%%i
echo OK - Python %PYVER% detecte
echo.

:: Installer les dependances
echo [2/5] Installation des dependances (PyQt6, PyInstaller)...
echo       Cela peut prendre 1-2 minutes...
echo.
pip install PyQt6 PyQt6-Charts pyinstaller --quiet --disable-pip-version-check
if errorlevel 1 (
    echo Tentative avec --user...
    pip install PyQt6 PyQt6-Charts pyinstaller --user --quiet --disable-pip-version-check
)
echo OK - Dependances installees
echo.

:: Compiler
echo [3/5] Compilation de l'executable...
echo       Cela peut prendre 2-3 minutes...
echo.

cd sources

if exist "..\icon.ico" (
    echo       Icone detectee, compilation avec icone...
    pyinstaller --onefile --windowed --name "ScoreInvest Portfolio v2" --icon="..\icon.ico" --clean --noconfirm ScoreInvestPortfolio.py
) else (
    echo       Compilation sans icone...
    pyinstaller --onefile --windowed --name "ScoreInvest Portfolio v2" --clean --noconfirm ScoreInvestPortfolio.py
)

if errorlevel 1 (
    color 0C
    echo.
    echo ERREUR lors de la compilation
    echo.
    pause
    exit /b 1
)

cd ..
echo OK - Compilation terminee
echo.

:: Deplacer l'exe
echo [4/5] Finalisation...
if exist "sources\dist\ScoreInvest Portfolio v2.exe" (
    move "sources\dist\ScoreInvest Portfolio v2.exe" "ScoreInvest Portfolio v2.exe" >nul
    echo OK - Executable cree: ScoreInvest Portfolio v2.exe
) else (
    echo ATTENTION: Exe non trouve dans sources\dist\
)
echo.

:: Nettoyage
echo [5/5] Nettoyage des fichiers temporaires...
rmdir /s /q sources\build 2>nul
rmdir /s /q sources\dist 2>nul
del /q sources\*.spec 2>nul
echo OK - Nettoyage termine
echo.

:: Succes
color 0A
echo.
echo ========================================================================
echo     COMPILATION REUSSIE !
echo     Fichier cree: ScoreInvest Portfolio v2.exe
echo     Double-cliquez dessus pour lancer l'application !
echo ========================================================================
echo.

:: Proposer de lancer
set /p LAUNCH="Voulez-vous lancer l'application maintenant ? (O/N) "
if /i "%LAUNCH%"=="O" (
    start "" "ScoreInvest Portfolio v2.exe"
)

echo.
pause
